# Email Setup Guide for POS System

This guide will help you set up email functionality for your local POS system running on XAMPP.

## 🚀 Quick Start

1. **Run the Setup Assistant** (Recommended):
   ```batch
   double-click: quick_install_script.bat
   ```

2. **Check PHP Requirements**:
   ```bash
   php setup_guides/check_php_requirements.php
   ```

3. **Fix PHP Configuration** (if needed):
   ```batch
   right-click and run as Administrator: fix_php_config.bat
   ```

## 📋 Prerequisites

Your system needs:
- ✅ XAMPP with PHP 7.0+ (you have PHP 8.2.12)
- ✅ PHPMailer library (already installed)
- ⚠️ Sockets extension enabled (needs fixing)
- ⚠️ OpenSSL extension enabled (already enabled)
- ✅ cURL extension enabled
- ✅ Internet connection for external SMTP

## 🔧 Setup Methods

### Method 1: External SMTP (⭐ RECOMMENDED)

Use external email services like Gmail or Outlook. **This is the most reliable method.**

#### Option A: Gmail SMTP
- **Guide**: `gmail_smtp_setup.md`
- **Requirements**: Gmail account with 2-Factor Authentication
- **Steps**: Enable 2FA → Generate App Password → Configure POS
- **Settings**:
  - Host: `smtp.gmail.com`
  - Port: `587`
  - Encryption: `TLS`

#### Option B: Outlook SMTP  
- **Guide**: `outlook_smtp_setup.md`
- **Requirements**: Outlook/Office365 account
- **Settings**:
  - Host: `smtp.office365.com`
  - Port: `587`
  - Encryption: `TLS`

### Method 2: Local SMTP Server

Install an SMTP server on your local machine.

- **Guide**: `local_smtp_server_setup.md`
- **Recommended**: hMailServer (free)
- **Use case**: When you need complete control or no internet access

## 🛠️ Installation Steps

### Step 1: Fix PHP Configuration

**Current Issues Found:**
- ❌ Sockets extension not enabled (CRITICAL)
- ❌ Internationalization extension not enabled (OPTIONAL)

**Fix automatically:**
```batch
Right-click "fix_php_config.bat" → Run as Administrator
```

**Or fix manually:**
1. Edit `C:\xampp\php\php.ini`
2. Find `;extension=sockets` and change to `extension=sockets`
3. Find `;extension=intl` and change to `extension=intl` (optional)
4. Save file
5. Restart Apache in XAMPP Control Panel

### Step 2: Choose Your Email Method

**For most users (RECOMMENDED):**
- Use Gmail or Outlook SMTP
- No additional software needed
- Most reliable
- Works from anywhere with internet

**For advanced users:**
- Install local SMTP server (hMailServer)
- Works without internet
- More configuration required

### Step 3: Configure POS System

1. Open your POS system in browser
2. Go to: **Settings → Email Settings**
3. Enter your chosen SMTP settings
4. Click **"Test Email Configuration"**
5. Check your test email inbox

## 📊 Current System Status

Based on the requirements check:

| Component | Status | Action Needed |
|-----------|--------|---------------|
| PHP Version (8.2.12) | ✅ PASS | None |
| OpenSSL Extension | ✅ PASS | None |
| cURL Extension | ✅ PASS | None |
| **Sockets Extension** | ❌ FAIL | **Enable in php.ini** |
| Multibyte String | ✅ PASS | None |
| Iconv Extension | ✅ PASS | None |
| PHPMailer Library | ✅ PASS | None |
| Network Connectivity | ✅ PASS | None |

**Critical Fix Needed:** Enable sockets extension for reliable SMTP functionality.

## 🔍 Testing & Troubleshooting

### Test Your Setup
1. Run: `php setup_guides/check_php_requirements.php`
2. Use POS system's "Test Email Configuration"
3. Check email delivery and error logs

### Common Issues

**❌ "Sockets extension not loaded"**
- Solution: Run `fix_php_config.bat` as Administrator
- Or manually enable in php.ini

**❌ "SMTP connection failed"**
- Check internet connection
- Verify SMTP settings (host, port, credentials)
- Try different ports (587, 465, 25)
- Check firewall settings

**❌ "Authentication failed"**
- Verify username/password
- For Gmail: Use App Password (not regular password)
- For Outlook: Ensure account allows SMTP

**❌ "Connection timeout"**  
- Check if ISP blocks SMTP ports
- Try alternative ports
- Test with different SMTP provider

### Debug Information
- PHP Version: 8.2.12 ✅
- Loaded Extensions: 38 total
- SMTP Ports Available: Gmail (587) ✅, Outlook (587) ✅
- Local SMTP: Not installed (optional)

## 📁 Files in This Guide

| File | Purpose |
|------|---------|
| `README.md` | This overview document |
| `quick_install_script.bat` | Interactive setup assistant |
| `check_php_requirements.php` | PHP environment checker |
| `fix_php_config.bat` | Automatic PHP configuration fixer |
| `gmail_smtp_setup.md` | Gmail SMTP setup guide |
| `outlook_smtp_setup.md` | Outlook SMTP setup guide |
| `local_smtp_server_setup.md` | Local SMTP server guide |

## 🔐 Security Recommendations

### For Production Use:
1. **Use App Passwords**: Never use main account passwords
2. **Enable TLS/SSL**: Always encrypt email transmission
3. **Restrict Access**: Limit SMTP relay to localhost only
4. **Strong Passwords**: Use complex passwords for email accounts
5. **Monitor Logs**: Check email sending logs regularly

### For Development:
1. **Test with Real Emails**: Use actual email addresses
2. **Check Spam Folders**: Verify emails aren't filtered
3. **Use Test Tools**: Consider MailHog for development testing
4. **Enable Debug**: Turn on SMTP debugging for troubleshooting

## 🆘 Getting Help

If you're still having issues:

1. **Run the diagnostic tools**:
   ```bash
   php setup_guides/check_php_requirements.php
   ```

2. **Check the logs**:
   - PHP error log: `C:\xampp\php\logs\php_error_log`
   - Apache error log: `C:\xampp\apache\logs\error.log`

3. **Try the interactive assistant**:
   ```batch
   quick_install_script.bat
   ```

4. **Common solutions**:
   - Restart Apache after php.ini changes
   - Check firewall settings
   - Verify internet connection
   - Test with different email providers

## ✅ Success Checklist

- [ ] PHP requirements check passes
- [ ] Sockets extension enabled
- [ ] SMTP settings configured in POS
- [ ] Test email sent successfully  
- [ ] Email received in inbox (not spam)
- [ ] Production settings secured

---

**Next Steps**: Once email is working, you can use it for:
- Customer payment reminders
- Low stock notifications  
- Sales reports
- Receipt emails
- System alerts

**Need more help?** Contact your system administrator or refer to the individual setup guides for detailed instructions. 